SetFactory("OpenCASCADE");

Box(1) = {0,0,0, 0.5,0.7,0.5};
Sphere(2) = {0.25, 0.20, 0.25, 0.03, -Pi/2, Pi/2, 2*Pi};

BooleanDifference(3) = { Volume{1}; Delete; }{ Volume{2}; Delete; };

Physical Surface("inlet") = {2};
Physical Surface("outlet") = {4};
Physical Surface("walls") = {3, 6, 5, 1};
Physical Surface("sphere") = {7};

Physical Volume("domain") = {3};

Field[1] = Box;
Field[1].VIn = 0.05;
Field[1].VOut = 2;
Field[1].XMax = 0.5;
Field[1].XMin = 0;
Field[1].YMax = 0.7;
Field[1].YMin = 0;
Field[1].ZMax = 0.5;
Field[1].ZMin = 0;

Field[2] = Ball;
Field[2].Radius = 0.031;
Field[2].VIn = 0.007;
Field[2].VOut = 2;
Field[2].XCenter = 0.25;
Field[2].YCenter = 0.20;
Field[2].ZCenter = 0.25;

Field[3] = Min;
Field[3].FieldsList = {1,2};
Background Field = 3;
