
import time
import numpy as np
import os.path
from firedrake import *


start_time = time.time()

"""
    ****************************************
    *               Settintgs              *
    **************************************** """
#________________ Kind of data ________________#
#input_data = "measurements"   # from experiments
input_data = "created"        # set the wavemaker
#______________ Temporal scheme _______________#
scheme = "SE"
#  "SE": Symplectic-Euler ; "SV": Stormer-Verlet
#__________________ Dimension _________________#
dim = "3D"
#"2D": R(t) and b(x); "3D": R(y,t) and/or b(x,y)
# if input = measurements, the dim must be 2D.
#______ Path and name of the saved files ______#
save_path = './'



"""
    *************************************************
    *      Definition of the space/time domain      *
    ************************************************* """
#______________________ Beach ______________________#
xb = 3.0                         # Start of the beach
sb = 0.2                         # Slope of the beach

#______________________ Basin ______________________#
g = 9.81                     # Gravitational constant
H0 = 1.0                # Depth at rest (flat bottom)
Hend = 0.5            # Depth at the end of the beach
Lx = xb +(H0-Hend)/sb                   # Length in x
Ly = 1.0                                # Length in y
Lw = 1.0                     # End of the x-transform

#______________________ Time _______________________#
T0 = 0.0                               # Initial time
t = T0                            # Temporal variable
Tend = 10.0                           # Final time
dt = 1.00*10**(-3)                        # Time-step

t_save = 0.0
dt_save = 0.01
ind=0
it_time_save=0
run_time_it = time.time()-start_time
i_dt = 0

res_coarse = 0.4
Nx_coarse = int(Lx/res_coarse) + 1               # Number of elements in x
Ny_coarse = int(Ly/res_coarse) + 1             # Number of elements in y
    
coarse_mesh = RectangleMesh(Nx_coarse,Ny_coarse,Lx,Ly,quadrilateral=True)
coarse_V = FunctionSpace(coarse_mesh, "CG", 1)
coarse_h = Function(coarse_V, name="h")
V_vec_c = VectorFunctionSpace(coarse_mesh, "CG", 1)
coarse_points = Function( V_vec_c , name="coarse_points")
coarse_points.interpolate(SpatialCoordinate(coarse_mesh))

medium_h_mapped = Function(coarse_V, name="mapped_m")

Nx_medium = int(Lx/0.2) + 1               # Number of elements in x
Ny_medium = int(Ly/0.2) + 1             # Number of elements in y
medium_mesh = RectangleMesh(Nx_medium,Ny_medium,Lx,Ly,quadrilateral=True)
medium_V = FunctionSpace(medium_mesh, "CG", 1)
medium_h = Function(medium_V, name="h")

i_dt=0
while t<Tend:
    """ *****************************************************************************
        *                               SAVE FUNCTIONS                              *
        ***************************************************************************** """
    if t_save <= t:
        print(i_dt)
        dumb_file_medium = DumbCheckpoint(save_path+"medium/h_"+str(i_dt), mode=FILE_READ)
        dumb_file_medium.load(medium_h)
        dumb_file_medium.close()
        coarse_data_m = medium_h.at(coarse_points.dat.data_ro)
        medium_h_mapped.dat.data[:] = coarse_data_m[:]

        t_save+=dt_save
        i_dt+=1

    t+=dt
